---
title: edit
description: Switch to a different change for editing
---

Switch your working directory to a different change for editing.

This command downloads all files from the specified change and replaces your
current working directory contents with them. It's similar to 'git checkout'
but in Pogo's centralized model.

Important notes:
- Any uncommitted local changes will be pushed to the current change before switching
- The change you switch to becomes your new working change
- You can edit any change, even if it has children (though pushing will require --force)
- Files in .pogoignore are not affected by this operation

Use this command to:
- Switch between different lines of development
- Go back to an earlier version to fix a bug
- Review someone else's changes
- Start working from a different base

This command pushes any changes before running.

## Usage

```bash
pogo edit
```

## Aliases

- `checkout`

## Flags

- `--force`, `-f`: Force push even if the change is readonly

## Examples

```bash
# Switch to change ab23
pogo edit ab23

# Switch to the change marked as "main"
pogo edit main

# Switch to a tagged release
pogo edit v1.0.0

# Use the checkout alias (familiar to Git users)
pogo checkout feature-branch
```

