# Files

## File tree (incomplete)

```
.
├── ARCHITECTURE.md
├── auth/
├── client/
├── cmd/
├── compressions/
├── config/
│   ├── server/
│   └── user/
├── db/
├── docs/
├── docker-compose.yaml
├── filecontents/
├── go.mod
├── go.sum
├── justfile
├── LICENSE
├── main.go
├── protos/
│   └── messages.proto
├── ptr/
│   └── ptr.go
├── server/
├── sqlc.yaml
└── sysid/
```

## General

- Never edit *_templ.go files, those are generated by templ!
- Never edit *.sqlc.go files, those are generated by sqlc!
- Never edit *.pb.go files, those are generated by protoc!
- Never edit `docs/completions/*` or `docs/man/*.1`, those are generated by cobra!
- Nothing is generated automatically. `just` is used as a build tool. Run `just prebuild` to generate all files (protobuf, sqlc, templ).
- This project uses Cobra as a CLI framework. The `cmd` package contains the commands that are available in the CLI.
- Protobuf definitions are in `protos/messages.proto`.
- The `client` package contains the client code for the gRPC connection.
- The `server` package contains the server code for the gRPC connection.
- Both the `client` and `server` packages must implement the gRPC service interface to be able to communicate with each other.
- sqlc generation is (most of the time) not picked up by the Go language server. Try a build to see the real errors.
- Don't run pogo in this repository! You will break things. Run it in `/Users/frank/Git/personal/pogotest` instead. Assume that there is a repository initialized and that a pogo server is running. The PostgreSQL database is running via docker named `pogo-db-1`.
- Run tests before you start working and after you are done. Run `just test` to run all tests.

## Architecture

Keep `ARCHITECTURE.md` up to date with any changes.
If you encounter any errors in `ARCHITECTURE.md`, fix them.